var isSmall = false;

function getInstancePref(key)
{
    return widget.preferenceForKey(widget.identifier + "-" + key);
}

function setInstancePref(key, value)
{
    widget.setPreferenceForKey(value, widget.identifier + "-" + key);
}

function changeZip(event)
{
    var zipC = parseInt(document.getElementById("zip").value);
    if(("" + zipC).length != 5)
        return;
    
    zip = zipC;
    startXMLRequest();
    
    setInstancePref("zip", zip);
}

function changeScale(event)
{
    scale = document.getElementById("scale").value;
    startXMLRequest();
    
    setInstancePref("scale", scale);
}

function NOAA(event)
{
    widget.openURL("http://www.weather.gov/forecasts/xml/");
}

function zoomSize(asSmall)
{
    isSmall = asSmall;
    
    window.resizeTo(isSmall ? 104 : 272, 164);
    if(isSmall)
        document.getElementById("day1").className = "day dayBoth";
    else
        document.getElementById("day1").className = "day dayLeft";
    
    setInstancePref("small", isSmall);
}

//
// Function: load()
// Called by HTML body element's onload event when the widget is ready to start
//
function load()
{
    var zipV = getInstancePref("zip");
    if(zipV)
    {
        zip = zipV;
        document.getElementById("zip").value = zip;
    }
    
    var scaleV = getInstancePref("scale");
    if(scaleV)
    {
        scale = scaleV;
        document.getElementById("scale").value = scale;
    }
    
    var smallV = getInstancePref("small");
    if(smallV)
        zoomSize(smallV);
    
    setTimeout(startXMLRequest, 5);
}

//
// Function: remove()
// Called when the widget has been removed from the Dashboard
//
function remove()
{
    setInstancePref("zip", null);
    setInstancePref("scale", null);
}

//
// Function: hide()
// Called when the widget has been hidden
//
function hide()
{
    if(refreshTimer != null)
    {
        clearTimeout(refreshTimer);
        refreshTimer = null;
    }
}

//
// Function: show()
// Called when the widget has been shown
//
function show()
{
    if(lastRefresh == null)
        startXMLRequest();
    else
    {
        var time = new Date();
        var now = time.getTime();
        if(now - refreshTime >= lastRefresh)
            startXMLRequest();
    }
}

//
// Function: sync()
// Called when the widget has been synchronized with .Mac
//
function sync()
{
    // Retrieve any preference values that you need to be synchronized here
    // Use this for an instance key's value:
    // instancePreferenceValue = widget.preferenceForKey(null, dashcode.createInstancePreferenceKey("your-key"));
    //
    // Or this for global key's value:
    // globalPreferenceValue = widget.preferenceForKey(null, "your-key");
}

//
// Function: showBack(event)
// Called when the info button is clicked to show the back of the widget
//
// event: onClick event from the info button
//
function showBack(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
    window.resizeTo(272, 164);

    if (window.widget) {
        widget.prepareForTransition("ToBack");
    }

    front.style.display = "none";
    back.style.display = "block";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
}

//
// Function: showFront(event)
// Called when the done button is clicked from the back of the widget
//
// event: onClick event from the done button
//
function showFront(event)
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");

    if (window.widget) {
        widget.prepareForTransition("ToFront");
    }

    front.style.display="block";
    back.style.display="none";

    if (window.widget) {
        setTimeout('widget.performTransition();', 0);
    }
    window.resizeTo(isSmall ? 104 : 272, 164);
}

if (window.widget) {
    widget.onremove = remove;
    widget.onhide = hide;
    widget.onshow = show;
    //widget.onsync = sync;
}